//*****************************************************************************
// Description     : 64 bit compatible purpose
// Target Device   : APG7400A
// Target Platform : Linux, C
// Date            : July 2017
// Version         : 1.0
//*****************************************************************************
#ifndef     __SYS_COMPATIBLE_H__
#define     __SYS_COMPATIBLE_H__

/******************************************************************************/
/* 64bit */
#define     qword   long long


/******************************************************************************/
/* calc elements */
#ifndef     _countof
#define     _countof(x) (sizeof(x) / sizeof(x[0]))
#endif


/******************************************************************************/
/* deleay of msec unit */
#include    <unistd.h>

#define     msleep(msec) {                                  \
    unsigned int    ___sec = (unsigned int)(msec / 1000) ;  \
    unsigned int    __msec = (unsigned int)(msec % 1000) ;  \
                                                            \
    if(___sec > 0) {                                        \
        sleep(___sec) ;                                     \
    }                                                       \
                                                            \
    usleep((useconds_t)(__msec * 1000)) ;                   \
}


#endif

